// @ts-nocheck
/* eslint-disable */
export const formatCurrency = (s, n) => {
  n = n > 0 && n <= 20 ? n : 2
  s = `${parseFloat(`${s}`.replace(/[^\d\.-]/g, '')).toFixed(n)}`
  const l = s.split('.')[0].split('').reverse()
  const r = s.split('.')[1]
  let t = ''
  for (let i = 0; i < l.length; i++) {
    t += l[i] + ((i + 1) % 3 == 0 && i + 1 != l.length ? ',' : '')
  }
  return t.split('').reverse().join('')
}
// 格式化千分位并补零
export const moneyFormat = (num) => {
  if (Number(num).toString() !== 'NaN') {
    // 添加千分符
    let _n = Number(num).toLocaleString()
    if (_n.indexOf('.') !== -1) {
      _n = `${_n}00`
    } else {
      _n = `${_n}.00`
    }
    // 因为有千分符所以，返回数据为字符串格式，无法做运算操作，适合做直接显示使用
    return _n.substring(0, _n.indexOf('.') + 3)
  }
  // console.log('参数格式有误')
}
// 金额大数字转换
export const bigNumberTransform = (value, type) => {
  const newValue = ['', '', '']
  let fr = 1000
  let num = 3
  let text1 = ''
  let text2 = ''
  let fm = 1
  if (value == '' || value == null || isNaN(value)) {
    return !type ? newValue : ''
  }
  if (value < 0) {
    value = Math.abs(value)
    text2 = '-'
  }
  while (value / fr >= 1) {
    fr *= 10
    num += 1
    // console.log('数字', value / fr, 'num:', num)
  }
  if (num <= 4) {
    // 千
    newValue[0] = value
    newValue[1] = ''
  } else if (num <= 8) {
    // 万
    // text1 = parseInt(num - 4) / 3 > 1 ? '千万' : '万'
    text1 = '万'
    // tslint:disable-next-line:no-shadowed-variable
    fm = text1 === '万' ? 10000 : 10000000
    if (value % fm === 0) {
      newValue[0] = `${parseInt(value / fm)}`
    } else {
      newValue[0] = `${parseFloat(value / fm).toFixed(2)}`
    }
    newValue[1] = text1
  } else {
    // 亿 if (num <= 16)
    // text1 = (num - 8) / 3 > 1 ? '千亿' : '亿'
    text1 = '亿'
    text1 = (num - 8) / 4 > 1 ? '万亿' : text1
    text1 = (num - 8) / 7 > 1 ? '千万亿' : text1
    text1 = (num - 8) / 10 > 1 ? '亿亿' : text1
    // tslint:disable-next-line:no-shadowed-variable
    fm = 1
    if (text1 === '亿') {
      fm = 100000000
    } else if (text1 === '千亿') {
      fm = 100000000000
    } else if (text1 === '万亿') {
      fm = 1000000000000
    } else if (text1 === '千万亿') {
      fm = 1000000000000000
    } else {
      fm = 1000000000000000000
    }
    if (value % fm === 0) {
      newValue[0] = `${parseInt(value / fm)}`
    } else {
      newValue[0] = `${parseFloat(value / fm).toFixed(2)}`
    }
    newValue[1] = text1
  }
  if (value < 1000) {
    newValue[0] = `${value}`
    newValue[1] = ''
  }
  newValue[0] = text2 ? text2 + newValue[0] : newValue[0]
  return !type ? newValue : newValue[0] + newValue[1]
}
// 格式化金额
export const formatMoney = (money) => {
  return money?.toLocaleString()
}
