/* eslint-disable */
import React, { useEffect, useState } from 'react';

import { Select, Space } from 'antd';
import { useRouter } from 'next/router';

import ContentBox from '~/components/contentBox';
import WxCodeModal from '~/components/wxCodeModal';
import { bigNumberTransform } from '~/utils/money';

import api, { AllType, NewsPageType, NewsTenderType, listNewsApi } from './api';
import Map from './components/map';
import RotationChart from './components/rotationChart';
import { Box } from './styled';
import commonApi from '~/api';

interface ColumnsType {
  title: string;
  router: string;
}

export default function WaterfallFlowBody() {
  const router = useRouter();

  const columns = [
    {
      title: '无人机出租',
      router: '/equipmentLeasing',
    },
    {
      title: '无人机销售',
      router: '/mall',
    },
    {
      title: '无人机保险',
      router: '/mall',
    },
    {
      title: '无人机培训',
      router: 'flyingHandService',
    },
    {
      title: '无人机服务',
      router: '/jobServices',
    },
    {
      title: '无人机工具软件',
      router: '/mall',
    },
  ];

  const [leftDomList, setLeftDomList] = useState(Array<{ element: JSX.Element; type?: string }>);

  const [rightTopDomList, setRightTopDomList] = useState<JSX.Element>();
  const [rightBottomDomList, setRightBottomDomList] = useState<JSX.Element>();
  const [wxCodeShow, setWXCodeShow] = useState<boolean>(false);
  const [wxCodeImg, setWxCodeImg] = useState<string>('');

  const onMoreChange = (value: { value: string; label: number }, index: number, option: []) => {
    const [item] = option.filter((item: any) => item.name === value.value);
    routerPath(index, item);
  };

  useEffect(() => {
    (async () => {
      const res2 = await api.HomeCategories({ type: 2 }); // 无人机培训
      const res4 = await api.HomeCategories({ type: 4 }); // 无人机销售
      const res1 = await api.HomeCategories({ type: 1 }); // 无人机出租
      const res3 = await api.HomeCategories({ type: 3 }); // 无人机服务
      const res5 = await api.HomeCategories({ type: 5 }); // 无人机保险
      const res6 = await api.HomeCategories({ type: 6 }); // 无人机软件
      const optionList: any = [
        res2.result,
        res4.result,
        res5.result,
        res3.result,
        res1.result,
        res6.result,
      ];
      const listValue: any = [
        res2.result,
        res4.result,
        res5.result,
        res3.result,
        res1.result,
        res6.result,
      ];
      setLeftDomList(
        columns.map((item, index) => {
          if (index < 3) {
            return {
              element: leftDom(item, index, listValue, optionList[index]),
              type: 'left',
            };
          }
          return {
            element: leftDom(item, index, listValue, optionList[index]),
            type: 'right',
          };
        }),
      );
      const res7 = await listNewsApi.listNewsPage({ pageNo: 1, pageSize: 5 });
      const res8 = await listNewsApi.listNewTenderInfo({
        pageNo: 1,
        pageSize: 6,
      });
      setRightTopDomList(rightDom(res7.result?.list!));
      setRightBottomDomList(rightDom2(res8.result?.list!));
    })();
    getWXCode();
  }, []);

  const routerPath = (index: number, item?: AllType) => {
    if (item) {
      router.push({
        pathname: columns[index].router,
        query: {
          categoryId: item.id,
          name: item.categoryName,
        },
      });
    }
  };

  const handleTenderApply = () => {
    setWXCodeShow(true);
  };
  const wxCodeModalCancel = () => {
    setWXCodeShow(false);
  };

  const leftDom = (
    item: ColumnsType,
    index: number,
    resultList: Array<Array<AllType>>,
    option: [],
  ) => {
    return (
      <div key={item.title} className='item'>
        <div className='item-title'>
          <div className='item-left'>
            <div className='item-left-label' onClick={() => routerPath(index)}>
              {item.title}
            </div>
          </div>
          <div key={item.title}>
            <Select
              className='select-box'
              placeholder='筛选'
              labelInValue
              onChange={(value) => onMoreChange(value, index, option)}
              bordered={false}
              dropdownMatchSelectWidth={false}
              options={option}
              fieldNames={{
                value: 'categoryName',
                label: 'categoryName',
              }}
            />
          </div>
        </div>
        <div className='item-body'>
          <Space size={[15, 0]} wrap>
            {resultList[index]?.map((item, indexer) => {
              return (
                <div
                  key={item.categoryName}
                  className={`item-bubble ${
                    indexer === 0 || indexer === 1 || indexer === 2 ? 'active' : ''
                  }`}
                  onClick={() => routerPath(index, item)}
                >
                  {item.categoryName}
                </div>
              );
            })}
          </Space>
        </div>
      </div>
    );
  };

  const rightDom = (list: Array<NewsPageType>) => {
    if (!list?.length) return;
    return (
      <div key={1009} className='right-box-item right-item'>
        <div className='title'>
          <div className='title-label' onClick={() => router.push('/projectInfo')}>
            行业新闻
          </div>
        </div>
        <div className='body'>
          {list?.map((item, index) => (
            <div
              key={item.id}
              className='body-item'
              onClick={() => router.push(`/projectInfo/newsArticle/${item.id}`)}
            >
              <div
                className={`item-ranking ${index === 0 ? 'one' : ''} ${index === 1 ? 'two' : ''} ${
                  index === 2 ? 'san' : ''
                }`}
              >
                {index + 1}
              </div>
              <div className='item-label' title={item.newsTitle}>
                {item.newsTitle}
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  };

  const rightDom2 = (list: Array<NewsTenderType>) => {
    if (!list?.length) return;
    return (
      <div key={1008} className='right-box-item right-item-second'>
        <div className='item-box'>
          <div className='title'>
            <div className='title-label' onClick={() => router.push('/projectInfo')}>
              招标快讯
            </div>
          </div>
          <div className='body'>
            {list?.map((item) => (
              <div key={item.id} className='body-item'>
                <div className='item-label' title={item.tenderTitle}>
                  {item.tenderTitle}
                  <div className='label-bottom'>{item.tenderPrice}</div>
                </div>
                <div
                  className={`item-right ${item.apply ? 'apply' : ''}`}
                  onClick={handleTenderApply}
                >
                  <div className='left'>{bigNumberTransform(item.tenderPrice * 10000, true)}</div>
                  <div className='right'>申请合作</div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    );
  };
  const getWXCode = () => {
    commonApi.listBannerImg('WX_CODE').then(({ result }) => {
      if (result) {
        setWxCodeImg(result[0].bannerImg);
      }
    });
  };
  return (
    <Box>
      <ContentBox
        boxIndex={1} // 分为左右两列，每列一个,从上而下
        leftcontentstyle={{
          width: '806px',
          margin: { top: 0, right: '10px', bottom: '10px', left: 0 },
        }}
        leftWaterfallDom={{
          columns: [{ noFor: true, element: <RotationChart key={45645645} /> }, ...leftDomList],
        }}
        rightRenderDom={{
          columns: [
            { element: <Map key={1001} /> },
            { element: rightTopDomList as JSX.Element },
            { element: rightBottomDomList as JSX.Element },
          ],
        }}
      />
      <WxCodeModal open={wxCodeShow} onCancel={wxCodeModalCancel} wxCodeImg={wxCodeImg} />
    </Box>
  );
}
