import request, { Response } from '~/api/request';

export interface PositioningInfoParams {
  lat: number;
  lon: number;
  pageNo: number;
  pageSize: number;
}

export interface Entiy {
  dizhi: string;
  jd: number;
  wd: number;
  range: number;
}

export interface ListPageJobInfoType {
  address: string;
  name: string;
  lon: number;
  lat: number;
  distance: number;
}

export interface FlyerBitmapEntiy {
  flyerName: string;
  phoneNum: string;
  lon: number;
  lat: number;
  distance: number;
}
export interface UavBitmapEntiy {
  uavName: string;
  online: number;
  lon: number;
  lat: number;
  distance: number;
  id: string;
}
export interface BitmapInfo<T> {
  pageNo: number;
  pageSize: number;
  list: T[];
  totalCount: number;
  totalPage: number;
}

export default {
  // web-首页-地图-全国点位
  listPositioningInfo: (
    params: PositioningInfoParams,
  ): Promise<Response<BitmapInfo<ListPageJobInfoType>>> => {
    return request('/release/website/getWebsiteList', 'get', params);
  },
  // web-首页-地图-全国飞手
  listFlyerBitmap: (
    params: PositioningInfoParams,
  ): Promise<Response<BitmapInfo<FlyerBitmapEntiy>>> => {
    return request('/release/website/flyer/bitmap', 'get', params);
  },
  // web-首页-地图-全国无人机
  listUavBitmap: (params: PositioningInfoParams): Promise<Response<BitmapInfo<UavBitmapEntiy>>> => {
    return request('/release/website/uav/bitmap', 'get', params);
  },
  // web-首页-地图-全国维修-海点数据
  listMaintainBitmap: (
    params: PositioningInfoParams,
  ): Promise<Response<BitmapInfo<ListPageJobInfoType>>> => {
    return request('/release/website/maintain/bitmap', 'get', params);
  },
};
