import request, { Response } from '~/api/request';
import { TypesResp } from '~/components/filter/api';

export interface ListPageFlyingInfoParams {
  pageNo: number;
  pageSize: number;
  flightSkillsId?: number;
  licenseId?: number;
  regionId?: number;
}

export interface Flying {
  id: number;
  price: number;
  supplierName: string;
  curriculumName: string;
  free: 0 | 1;
  curriculumDesc: string;
  videoUrl: string;
  surfaceUrl: string;
}

export interface ListPageFlyingInfoResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Flying>;
  totalCount: 0;
  totalPage: 0;
}

export interface SkillsType {
  type: string;
  id: number;
  skillsName: string;
  label: string | number;
  value: string | number;
}

export interface RegionResp {
  childInfo: RegionResp[] | null;
  id: number;
  level: number;
  name: string;
  pid: number;
}

export interface PilotRegistrationParams {
  city?: number;
  drivingLicense?: number;
  industryAppAuth?: Array<number>;
  province?: number;
  remark?: string;
  telephone?: string;
  uavLicenseLevelOne?: number;
  uavLicenseLevelTwo?: number;
}

export default {
  // web-飞手培训-分页
  listPageJobServicesInfo: (
    params: ListPageFlyingInfoParams,
  ): Promise<Response<ListPageFlyingInfoResp>> => {
    return request('/release/curriculum/queryCurriculumInfoList', 'post', params);
  },
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
  PilotLicense: (): Promise<Response<Array<RegionResp>>> => {
    return request('/release/curriculum/getDronePilotLicense');
  },
  IndustryFlightSkills: (): Promise<Response<Array<SkillsType>>> => {
    return request('/release/curriculum/getIndustryFlightSkills');
  },
  PilotRegistrations: (params: PilotRegistrationParams): Promise<Response<Array<SkillsType>>> => {
    return request('/release/curriculum/pilotRegistration', 'post', params);
  },
  FlightSkills: (params: { type: 3 }): Promise<Response<Array<TypesResp>>> => {
    return request('/pms/classify/queryCategoryInfoByType', 'get', params);
  },
};
