import styled from 'styled-components';

export const Box = styled.div`
  box-sizing: border-box;
  .img_wrapper {
    width: 300px;
    .img_content {
      position: relative;
      border: 1px solid #f2f2f2;
      box-sizing: border-box;
      width: 300px;
      height: 300px;
      &:hover {
        cursor: move;
      }
      .movebox {
        width: 100%;
        height: 100%;
        position: absolute;
        left: 0;
        top: 0;
        z-index: 1;
        &:hover ~ .img_big {
          display: block;
        }
      }
      .mask {
        width: 50%;
        height: 50%;
        position: absolute;
        left: 0;
        top: 0;
        display: none;
        background-color: #fedef4;
        box-sizing: border-box;
        opacity: 0.5;
        border: 1px solid #aaa;
        cursor: move;
      }
      .img_small {
        width: 100%;
        height: 100%;
        //object-fit: contain;
      }
      &:hover .mask {
        display: block;
      }
      .img_big {
        background-color: #fff;
        z-index: 10;
        display: none;
        position: absolute;
        top: 0;
        left: 349px;
        box-sizing: border-box;
        border: 1px solid #f2f2f2;
        width: 450px;
        height: 450px;
        overflow: hidden;
        img {
          width: 200%;
          height: 200%;
          position: absolute;
          left: 0;
          top: 0;
        }
      }
    }
    .img_list_wrapper {
      padding-top: 20px;
      width: 300px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      .img_list_content {
        width: 240px;
        overflow: hidden;
        .img_list {
          display: flex;
          flex-wrap: nowrap;
          transition: all 0.3s linear;
          img {
            cursor: pointer;
            border: 1px solid #fff;
            box-sizing: border-box;
            width: 60px;
            height: 60px;
          }
          .activeImg {
            border: 1px solid rgb(214, 70, 70);
          }
        }
      }
      &::v-deep .el-icon-arrow-left {
        cursor: pointer;
        font-size: 30px;
        width: 30px;
        height: 70px;
        line-height: 70px;
      }
      &::v-deep .el-icon-arrow-right {
        cursor: pointer;
        font-size: 30px;
        width: 30px;
        height: 70px;
        line-height: 70px;
      }
    }
  }
`;
