import { RightOutlined } from "@ant-design/icons";
import { Col, Row } from "antd";
import styles from "./index.module.scss";
import Image from "next/image";
import { useState, useEffect } from "react";
import api, { Item } from "./api";
import { useRouter } from "next/router";

type Props = {
  params?: {
    cityCode: number; //市编码
    date: string; //时间 2023-05-19
    districtCode: number; //区编码
    provinceCode: number; //省编码
  };
};

export default function News(props: Props) {
  const [list, setList] = useState<Array<Item>>([]);
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 5,
  });
  const [count, setCount] = useState(0);
  const [abort, setAbort] = useState<AbortController | null>(null);
  const router = useRouter();

  useEffect(() => {
    //中断前一次请求
    abort?.abort();
    setAbort(new AbortController());
  }, [pageParams, props.params]);

  useEffect(() => {
    if (!abort) {
      return;
    }
    api
      .listNewsPage(
        {
          ...pageParams,
          ...props.params,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setList(res.result?.list || []);
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  return (
    <Row justify="space-between">
      <Col className={styles.new}>
        {list.map((item) => {
          return (
            <div
              className={styles.item}
              key={item.id}
              onClick={() => router.push("/projectInfo/newsArticle/" + item.id)}
            >
              <Image
                className={styles.logo}
                src={item.surfaceImg}
                alt=""
                width={120}
                height={80}
              ></Image>
              <div className={styles.info}>
                <div className={styles.title}>{item.newsTitle}</div>
              </div>
            </div>
          );
        })}
      </Col>
    </Row>
  );
}
