import { Button, Col, Image, Modal, Row, Space } from "antd";
import { useState } from "react";
import errImg from "~/assets/errImg";
import styles from "./index.module.scss";

type Props = {
  open?: boolean;
  onOk?: (e: React.MouseEvent<HTMLButtonElement>) => void;
  onCancel?: (e: React.MouseEvent<HTMLButtonElement>) => void;
};
export default function IntentionModal(props: Props) {
  const list = [1, 1, 1, 1, 1, 1, 1, 1, 1];

  return (
    <Modal
      open={props.open}
      onOk={props.onOk}
      onCancel={props.onCancel}
      width={420}
      style={{ padding: 0 }}
      className={styles.model}
      footer={
        <div style={{ padding: "13px 36px" }}>
          <Button type="primary" className={styles.font5} style={{width: '100%', height: 44}}>提交意向</Button>
        </div>
      }
    >
      <Row style={{ padding: "22px 39px 12px 39px" }} wrap={false}>
        <Col>
          <Image
            width={100}
            height={100}
            fallback={errImg}
            style={{ borderRadius: 8 }}
          ></Image>
        </Col>
        <Col flex="auto" style={{ marginLeft: 13, width: 230 }}>
          <div
            className={`${styles.font1} ${styles.ellipsis1}`}
            style={{ marginTop: 28 }}
          >
            垂直起降固定翼 插翅虎M9
          </div>
          <div
            className={`${styles.font2} ${styles.ellipsis2}`}
            style={{ marginTop: 7 }}
          >
            已选:入云龙【机壳喷绘】+金眼彪Z40【222222222222222222222222233333555555555555555
          </div>
        </Col>
      </Row>
      <div style={{ paddingRight: 13 }}>
        <div className={styles.specsContent}>
          <div className={styles.font3} style={{}}>
            无人机
          </div>
          <div>
            <div
              className={styles.font2}
              style={{ marginBottom: 5, marginTop: 11 }}
            >
              入云龙
            </div>
            <Space size={10} direction="vertical" style={{ width: "100%" }}>
              {list.map((item, i) => {
                return (
                  <Row
                    key={i}
                    align="middle"
                    wrap={false}
                    style={{
                      borderRadius: 5,
                      border: "1px solid #d6d6d6",
                      height: 50,
                    }}
                  >
                    <Col style={{ marginLeft: 7 }}>
                      <Image width={52} height={36} src="" fallback={errImg} preview={false}></Image>
                    </Col>
                    <Col
                      className={`${styles.ellipsis1} ${styles.font4}`}
                      style={{ width: 238, marginLeft: 18 }}
                    >
                      入云龙1-机壳喷绘
                    </Col>
                  </Row>
                );
              })}
            </Space>
          </div>
        </div>
      </div>
    </Modal>
  );
}
