import request, { Response } from '~/api/request';

export interface GetWebDeviceDetailParams {
  id:number
}

export interface WareImgsType {
  id: number,
  wareInfoId: number | null,
  imgUrl: string,
  imgType: number
}

export interface GetWebDeviceDetailResult {
      id: number,
      wareNo: string,
      wareTitle: string,
      wareTypeId: number,
      wareStatus: number,
      payStatus: number,
      minDeposit: number,
      maxDeposit: number,
      minRent: number,
      maxRent: number,
      totalStock: number,
      totalSale: number,
      skuNum: number,
      tags: [
        string,
        string
      ],
      wareImgs: Array<WareImgsType>,
      warePropDTO: number | null,
      wareDetailContent: string | TrustedHTML
}

export default {
  //web-设备租赁-详情
  listDetailDeviceInfo: (params: GetWebDeviceDetailParams): Promise<Response<GetWebDeviceDetailResult>> => {
    return request('/pms/webDevice/detail', 'get', params)
  }
}