import { Button, Col, Divider, Form, Input, Row } from "antd";
import { useRouter } from "next/router";
import LayoutView from "~/components/layout";
import api from "./api";
import styles from "./index.module.scss";

export default function JoinPolicy() {
  const router = useRouter();
  //提交
  const onFinish = (values: any) => {
    console.log(values);
    api
      .cooperationApply({
        ...values,
        userAccountId: 1,
        cooperationTagId: router.query.tagId,
      })
      .then((res) => {
        console.log("提交结果", res);
        if (res.result === "已通过") {
          window.messageApi.success(res.result);
          setTimeout(() => {
            router.push("/");
          }, 1500);
        } else {
          window.messageApi.error(res.message);
        }
      });
  };

  return (
    <LayoutView>
      <div className={styles.banner}></div>
      <div
        className="page"
        style={{
          background: "#fff",
          position: "relative",
          zIndex: 1,
          marginTop: 60,
          paddingBottom: 63,
        }}
      >
        <div
          className={styles.font1}
          style={{ textAlign: "center", paddingTop: 40, paddingBottom: 30 }}
        >
          加盟入驻政策
        </div>
        <div
          className={styles.font2}
          style={{ paddingLeft: 50, paddingRight: 50 }}
        >
          1.每月自动获取一张高额度优惠券
          <br /> 2.流量扶持和店铺曝光度
          <br />
          3成为科比特指定官方生态合作伙伴
          <br /> 4.享受不低于1亿制造采购补贴
          <br /> 5.无人机产业链资源共享
          <br /> 6.享受价值5亿产业链订单
          <br /> 7.享受一对一代运营服务
          <br /> 8.享受无人机生态圈资源
          <br /> 9.成为科比特指定官方生态
          <br />
          10.享受无人机生态圈资源合作伙伴
          <br />
          11.受价值5亿产业链订单
          <br />
          12.成为科比特指定官方生态合作伙伴
        </div>
        <Divider />
        <div
          className={styles.font1}
          style={{ textAlign: "center", marginBottom: 28 }}
        >
          申请加盟入驻
        </div>
        <Row justify={"center"}>
          <Col style={{ width: 400 }}>
            <Form labelAlign="left" labelCol={{ span: 5 }} onFinish={onFinish}>
              <Form.Item
                label="姓名"
                name="applyName"
                rules={[{ required: true }]}
              >
                <Input placeholder="请输入姓名"></Input>
              </Form.Item>
              <Form.Item
                label="联系方式"
                name="applyPhone"
                rules={[{ required: true }]}
              >
                <Input placeholder="请输入手机号"></Input>
              </Form.Item>
              <Form.Item name="remark">
                <Input.TextArea placeholder="其它信息"></Input.TextArea>
              </Form.Item>
              <Row justify={"center"}>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginTop: 11, width: 200 }}
                  size="large"
                >
                  提交申请
                </Button>
              </Row>
            </Form>
          </Col>
        </Row>
      </div>
    </LayoutView>
  );
}
