import request, { Response } from "~/api/request";

export interface RegionResp {
  childInfo?: RegionResp[] | null;
  id: number;
  level: number;
  name: string;
  pid: number;
}

export interface UserInfoParams {
  userAccountId: number;
}

export interface UserInfoResp {
  id: number;
  accountType: number;
  uid: string;
  phoneNum: string;
  userName: string;
  nickName: string;
  userImg: string;
  userSex: number;
  email: string;
  source: number;
  accountStatus: number;
  remark: string;
  portType: number;
  createTime: string;
}

export default {
  //获取区域数据
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request("/pms/webDevice/getSecondDistrictInfo");
  },
  //获取用户基本信息
  userInfo: (params: UserInfoParams): Promise<Response<UserInfoResp>> => {
    return request("/userapp/user-account/info", "get", params, {});
  },
};
