import React, { useEffect, useState } from 'react';
import { Tabs, Button, Cascader, Space, DatePicker, DatePickerProps } from 'antd';
import styles from './index.module.scss';
import Layout from '~/components/layout';
import Requirements from './components/requirements'; //项目需求
import Bids from './components/bids'; //招投标项目
import Cases from './components/cases'; //业务案例
import News from './components/news'; //行业新闻
import commonApi, { RegionResp } from '~/api';

export interface Params {
  cityCode?: number; //市编码
  date?: string; //时间 2023-05-19
  districtCode?: number; //区编码
  provinceCode?: number; //省编码
}

const items = (params: any) =>
  [/* "项目需求", */ '招标快讯', '业务案例', '行业新闻'].map((value) => {
    let children: JSX.Element | string = <></>;

    switch (value) {
      case '项目需求':
        children = <Requirements params={params}></Requirements>;
        break;

      case '招标快讯':
        children = <Bids params={params}></Bids>;
        break;

      case '业务案例':
        children = <Cases params={params}></Cases>;
        break;

      case '行业新闻':
        children = <News params={params}></News>;
        break;
    }
    return {
      label: `${value}`,
      key: value,
      children: children,
    };
  });

export default function ProjectInfo() {
  const [region, setRegion] = useState<Array<RegionResp>>([]);
  const [params, setParams] = useState<Params | null>({});

  useEffect(() => {
    window!.document!.querySelector('body')!.style.background = '#fff';
    commonApi.region().then((res) => {
      let temp = res.result || [];
      let temp1: Array<RegionResp> = [];
      if (res.result) {
        temp1 = temp.map((item) => {
          let t = {
            ...item,
            id: item.id,
          };
          return t;
        });
      }
      setRegion(temp1);
    });
  }, []);

  const onRegionChange = (value: Array<string>, list: Array<RegionResp>) => {
    console.log(value);
    let params1: Params = {
      provinceCode: undefined,
      districtCode: undefined,
    };
    list?.forEach((item) => {
      if (item.level == 1) {
        params1.provinceCode = item.id;
      } else if (item.level == 2) {
        params1.districtCode = item.id;
      }
    });
    setParams({
      ...params,
      ...params1,
    });
  };

  const onDateChange: DatePickerProps['onChange'] = (date, dateString) => {
    console.log(date, dateString);
    setParams({
      ...params,
      date: dateString || undefined,
    });
  };
  return (
    <Layout layoutStyle={{ backgroundColor: '#fff' }} hideFooter>
      <div style={{ backgroundColor: '#fff', minHeight: 820 }}>
        <div className='page'>
          <div className={styles.bannerWrap}>
            <div className={styles.banner}></div>
          </div>

          <Tabs
            className={styles.tabs}
            tabBarExtraContent={
              <Space size={8} style={{ marginRight: 25 }}>
                {
                  <Cascader
                    options={region}
                    //@ts-ignore
                    onChange={onRegionChange}
                    placeholder='选择省市'
                    borderRadiusSM={6}
                    fieldNames={{
                      label: 'name',
                      value: 'id',
                      // children: "childInfo",
                    }}
                    changeOnSelect
                  />
                }
                <DatePicker onChange={onDateChange} />
              </Space>
            }
            items={items(params)}
            tabBarGutter={41}
            destroyInactiveTabPane={true}
          />
        </div>
      </div>
    </Layout>
  );
}
