import request, { Response } from '~/api/request';
import { RegionResp } from '~/components/filter/api';
export interface ListPageJobInfoParams {
  pageNo: number;
  pageSize: number;
  appTypeId?: number;
  industryId?: number;
  inspectionName?: string;
  string?: number;
  regionId?: number;
}

export interface JobDetail {
  id?: number;
  content?: string;
  contentImgs?: string[] | null;
  contentVideo?: string | null;
  star?: number;
  img?: string | null;
  type?: number;
  name?: string;
  time?: number | string;
}

export interface ListPageJobInfoResp {
  id: number;
  serviceName: string;
  pictureUrl: string;
  videoUrl: string;
  teamPoster: string;
  evaluateInfo: Array<JobDetail>;
  item: number;
  coverPlan: string;
  serviceIntroduction: string;
  inspComtList: [];
}

export interface GetJobServicesDetailParams {
  id: number;
}
export interface GetOrderTaskParams {
  address: string;
  city: string;
  endTime: string;
  images?: [];
  inspectionId: number;
  lat: number;
  lon: number;
  province: string;
  startTime: string;
  taskDescription?: string;
}

export default {
  //web-作业服务-详情
  listDetailJobServicesInfo: (
    params: GetJobServicesDetailParams,
  ): Promise<Response<ListPageJobInfoResp>> => {
    return request('/pms/backstage/work/queryWorkService', 'get', params);
  },
  //web-作业服务-详情-立即预约
  insertOrderTask: (params: GetOrderTaskParams): Promise<Response<null>> => {
    return request('/oms/serviceOrderTask/insertOrderTask', 'post', params);
  },
  //区域
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
};
