import React from "react";
import { ConfigProvider } from "antd";

const withTheme = (node: JSX.Element) => (
  <>
    <ConfigProvider
      theme={{
        token: {
          colorPrimary: "rgba(255, 85, 45, 1)",
        },
      }}
    >
      <ConfigProvider
        theme={{
          token: {
            borderRadius: 6,
          },
        }}
      >
        {node}
      </ConfigProvider>
    </ConfigProvider>
  </>
);

export default withTheme;