import React, { useEffect, useState } from "react";
import {
  Tabs,
  Button,
  Cascader,
  Space,
  DatePicker,
  DatePickerProps,
} from "antd";
import styles from "./index.module.scss";
import Layout from "~/components/layout";
import Requirements from "./components/requirements"; //项目需求
import Bids from "./components/bids"; //招投标项目
import Cases from "./components/cases"; //业务案例
import News from "./components/news"; //行业新闻
import commonApi, { RegionResp } from "~/api";

export interface Params {
  cityCode?: number; //市编码
  date?: string; //时间 2023-05-19
  districtCode?: number; //区编码
  provinceCode?: number; //省编码
}

interface RegionOptions extends RegionResp {
  value: string;
}

const items = ["项目需求", "招投标项目", "业务案例", "行业新闻"].map(
  (value) => {
    let children: JSX.Element | string = <></>;

    switch (value) {
      case "项目需求":
        children = <Requirements></Requirements>;
        break;

      case "招投标项目":
        children = <Bids></Bids>;
        break;

      case "业务案例":
        children = <Cases></Cases>;
        break;

      case "行业新闻":
        children = <News></News>;
        break;
    }
    return {
      label: `${value}`,
      key: value,
      children: children,
    };
  }
);

export default function ProjectInfo() {
  const [region, setRegion] = useState<Array<RegionOptions>>([]);
  const [params, setParams] = useState<Params | null>({});

  useEffect(() => {
    commonApi.region().then((res) => {
      let temp = res.result || [];
      let temp1: Array<RegionOptions> = [];
      if (res.result) {
        temp1 = temp.map((item) => {
          let t = {
            ...item,
            value: item.id + "," + item.level,
          };
          return t;
        });
      }
      setRegion(temp1);
    });
  }, []);

  const onRegionChange = (value: string) => {
    console.log(value);
  };

  const onDateChange: DatePickerProps["onChange"] = (date, dateString) => {
    console.log(date, dateString);
    setParams({
      ...params,
      date: dateString,
    });
  };
  return (
    <Layout layoutStyle={{ backgroundColor: "#fff" }}>
      <div style={{ backgroundColor: "#fff", minHeight: 820 }}>
        <div className="page">
          <div className={styles.bannerWrap}>
            <div className={styles.banner}></div>
          </div>

          <Tabs
            className={styles.tabs}
            tabBarExtraContent={
              <Space size={8} style={{ marginRight: 25 }}>
                {
                  <Cascader
                    options={region}
                    //@ts-ignore
                    onChange={onRegionChange}
                    placeholder="选择省市"
                    borderRadiusSM={6}
                    fieldNames={{
                      label: "name",
                      value: "value",
                      children: "childInfo",
                    }}
                    changeOnSelect
                  />
                }
                <DatePicker onChange={onDateChange} />
              </Space>
            }
            items={items}
            tabBarGutter={41}
          />
        </div>
      </div>
    </Layout>
  );
}
