import styled from "styled-components";

export default function Style() {
  return <></>;
}

export const Box = styled.div`
  box-sizing: border-box;
  padding-top: 24px;
  width: 1200px;
  margin: 0 auto;
  .item {
    height: 343px;
    transition: all 0.5s;
    &-title {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 0 25px;
      height: 75px;
      background: #ffffff;
      box-shadow: 10px 10px 20px 0px rgba(228, 228, 228, 0.3);
      border-radius: 6px 6px 0px 0px;
      .item-left {
        display: flex;
        justify-content: space-around;
        align-items: center;
        &-icon {
          width: 40px;
          height: 40px;
        }
        &-label {
          height: 32px;
          font-size: 20px;
          font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
          font-weight: bold;
          color: #000000;
          line-height: 32px;
        }
      }
    }
    &-body {
      padding-left: 10px;
      height: 268px;
      background: #ffffff;
      box-shadow: 10px 10px 20px 0px rgba(228, 228, 228, 0.3);
      border-radius: 0px 0px 6px 6px;
      .item-bubble {
        /* width: 80px; */
        padding: 0 5px;
        height: 32px;
        line-height: 32px;
        background: #f4f6f9;
        border-radius: 19px;
        text-align: center;
        cursor: pointer;
        &.active {
          color: #ff552d;
        }
      }
    }
    &:hover {
      box-shadow: 20px 20px 10px 0px rgba(228, 228, 228, 1);
    }
  }
  .right-item {
    height: 344px;
    background-color: #fff;
    .title {
      display: flex;
      align-items: center;
      padding: 0 25px;
      height: 60px;
      font-size: 20px;
      font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
      font-weight: bold;
      color: #000000;
      line-height: 25px;
    }
    .body {
      height: 284px;
      overflow-y: auto;
      &-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 70px;
        padding: 0 20px;
        .item-label {
          width: 217px;
          height: 40px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #323232;
          line-height: 21px;
          word-wrap: break-word;
        }
        .item-image {
          width: 96px;
          height: 60px;
          background: #d8d8d8;
          border-radius: 6px;
        }
      }
    }
  }
  .right-item-second {
    height: 510px;
    background-color: #fff;
    .title {
      display: flex;
      align-items: center;
      padding: 0 25px;
      height: 62px;
      font-size: 20px;
      font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
      font-weight: bold;
      color: #000000;
      line-height: 25px;
    }
    .body {
      height: 448px;
      overflow-y: auto;
      &-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 88px;
        padding: 0 20px;
        .item-label {
          width: 217px;
          height: 40px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #323232;
          line-height: 21px;
          word-wrap: break-word;
          .label-top {
            text-overflow: -o-ellipsis-lastline;
            overflow: hidden;				//溢出内容隐藏
            text-overflow: ellipsis;		//文本溢出部分用省略号表示
            display: -webkit-box;			//特别显示模式
            -webkit-line-clamp: 2;			//行数
            line-clamp: 2;					
            -webkit-box-orient: vertical;	//盒子中内容竖直排列
          }
          .label-bottom {
            font-size: 15px;
            font-family: PingFangSC-Medium, PingFang SC;
            font-weight: 500;
            color: #ff552d;
          }
        }
        .item-right {
          .btn {
            text-align: center;
            background: #ff552d;
            border-radius: 14px;
            font-size: 14px;
            font-family: MicrosoftYaHei;
            color: #ffffff;
          }
        }
      }
    }
  }
`;
