import { Space, Tag } from "antd";
import { FilterResult } from "../..";
import styles from "../../index.module.scss";

type Props = {
  data: FilterResult;
  onDel: (key: string) => void;
};
export default function ResultItem({data, onDel}: Props) {
  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>已选：</div>
      <div className={styles.filterItemMain}>
        <Space size={10}>
          {data &&
            Object.keys(data).map((key) => {
              //@ts-ignore
              let item = data[key];
              return (
                <Tag
                  closable
                  onClose={(e: React.MouseEvent<HTMLElement, MouseEvent>) => {
                    onDel(key);
                  }}
                  key={key}
                >
                  {item?.name}
                </Tag>
              );
            })}
        </Space>
      </div>
    </div>
  );
}
