import styled from "styled-components";
import button from "./assets/button.png";
import xwbg from "./assets/xwbg.png";

export default function Style() {
  return <></>;
}

export const Box = styled.div`
  box-sizing: border-box;
  padding-top: 16px;
  width: 1200px;
  margin: 0 auto;
  .item {
    transition: all 0.5s;
    border-radius: 6px;
    &-title {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 0 20px;
      height: 46px;
      background: #ffffff;
      box-shadow: 10px 10px 20px 0px rgba(228, 228, 228, 0.3);
      border-radius: 6px 6px 0px 0px;
      border-bottom: 1px solid #f1f1f1;
      .item-left {
        display: flex;
        justify-content: space-around;
        align-items: center;
        &-icon {
          width: 40px;
          height: 40px;
        }
        &-label {
          height: 32px;
          font-size: 16px;
          font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
          font-weight: bold;
          color: #000000;
          line-height: 32px;
          &:hover {
            cursor: pointer;
            color: #ff552d;
          }
        }
      }
      .select-box {
        /* background: #e0eeff; */
        /* border-radius: 2px; */
        /* border: 1px solid #aad0ff; */
        font-size: 12px;
        width: 49px;
        .ant-select-selection-placeholder {
          color: #297ce0;
          -webkit-padding-end: 0;
          padding-inline-end: 0;
        }
        .ant-select-selector {
          font-size: 13px;
          padding: 0 0 0 5px;
        }
        .ant-select-arrow {
          right: 2px;
          color: #297ce0;
        }
      }
    }
    &-body {
      padding: 5px 20px 10px 20px;
      background: #ffffff;
      border-radius: 0px 0px 6px 6px;
      .item-bubble {
        font-weight: 520;
        height: 32px;
        line-height: 32px;
        font-size: 14px;
        text-align: center;
        color: #4a4a4a;
        cursor: pointer;
        font-family: MicrosoftYaHei;
        &.active {
          color: #ff552d;
        }
        &:hover {
          color: #ff552d;
        }
      }
      .item-bottom {
        width: 371px;
        height: 30px;
        line-height: 30px;
        background: #f5f5f5;
        border-radius: 2px;
        text-align: center;
        font-size: 13px;
        font-family: MicrosoftYaHei;
        color: #4a4a4a;
        cursor: pointer;
        margin: 5px auto 0 auto;
      }
    }
  }
  .right-item {
    background-color: #fff;
    border-radius: 6px;
    .title {
      display: flex;
      align-items: center;
      padding: 0 20px 0 20px;
      height: 46px;
      font-size: 16px;
      font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
      font-weight: bold;
      color: #000000;
      line-height: 25px;
      &-label {
        cursor: pointer;
        font-size: 16px;
        font-weight: 100;
        &:hover {
          color: #ff552d;
        }
      }
    }
    /* .body {
      height: 284px;
      overflow-y: hidden;
      &-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 70px;
        padding: 0 20px;
        .item-label {
          width: 217px;
          height: 40px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #323232;
          line-height: 21px;
          overflow: hidden; //溢出内容隐藏
          text-overflow: ellipsis; //文本溢出部分用省略号表示
          display: -webkit-box; //特别显示模式
          -webkit-line-clamp: 2; //行数
          line-clamp: 2;
          -webkit-box-orient: vertical; //盒子中内容竖直排列
        }
        .item-image {
          width: 96px;
          height: 60px;
          background: #d8d8d8;
          border-radius: 6px;
        }
      }
    } */
    .body {
      border-radius: 0 0 6px 6px;
      .body-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0 23px 0 19px;
        height: 32px;
        cursor: pointer;
        .item-ranking {
          color: #9295a3;
          &.one {
            color: #ff2c46;
          }
          &.two {
            color: #ff6602;
          }
          &.san {
            color: #faa910;
          }
        }
        .item-label {
          width: 325px;
          height: 20px;
          line-height: 19px;
          font-size: 14px;
          font-family: MicrosoftYaHei;
          color: #323232;
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
          &:hover {
          color: #ff552d;
          }
        }
      }
    }
  }
  .right-item-second {
    border-radius: 6px;
    background-color: #fff;
    background: url(${xwbg.src}) no-repeat;
    background-size: contain;
    .title {
      display: flex;
      align-items: center;
      padding: 0 20px 0 20px;
      height: 48px;
      font-size: 16px;
      font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
      font-weight: bold;
      color: #000000;
      line-height: 25px;
      &-label {
        cursor: pointer;
        font-size: 16px;
        font-weight: 100;
        &:hover {
          color: #ff552d;
        }
      }
    }
    /* .body {
      overflow-y: hidden;
      &-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 88px;
        padding: 0 20px;
        .item-label {
          width: 217px;
          height: 40px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #323232;
          line-height: 21px;
          word-wrap: break-word;
          .label-top {
            text-overflow: -o-ellipsis-lastline;
            overflow: hidden; //溢出内容隐藏
            text-overflow: ellipsis; //文本溢出部分用省略号表示
            display: -webkit-box; //特别显示模式
            -webkit-line-clamp: 2; //行数
            line-clamp: 2;
            -webkit-box-orient: vertical; //盒子中内容竖直排列
          }
          .label-bottom {
            font-size: 15px;
            font-family: PingFangSC-Medium, PingFang SC;
            font-weight: 500;
            color: #ff552d;
          }
        }
        .item-right {
          .btn {
            text-align: center;
            background: #ff552d;
            border-radius: 14px;
            font-size: 14px;
            font-family: MicrosoftYaHei;
            color: #ffffff;
          }
        }
      }
    } */
    .body {
      .body-item {
        display: flex;
        justify-content: space-between;
        width: 384px;
        height: 32px;
        padding: 0 20px 0 20px;
        .item-label {
          width: 239px;
          height: 20px;
          font-size: 14px;
          font-family: MicrosoftYaHei;
          color: #323232;
          line-height: 19px;
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
        }
        .item-right {
          display: flex;
          justify-content: space-between;
          padding: 0 5px;
          width: 103px;
          height: 22px;
          background: url(${button.src}) no-repeat;
          background-size: contain;
          cursor: pointer;
          .left {
            width: 35px;
            height: 22px;
            line-height: 22px;
            font-size: 11px;
            font-family: PingFangSC-Medium, PingFang SC;
            font-weight: 500;
            color: #ff4500;
            text-align: center;
            left: 4px;
            top: 0;
          }
          .right {
            width: 48px;
            height: 22px;
            line-height: 22px;
            font-size: 11px;
            font-family: MicrosoftYaHei;
            color: #ffffff;
          }
        }
      }
    }
  }
`;
