import React,{ useEffect ,useState} from 'react'
import {Box} from './styled'
import {Cascader,Select} from 'antd'
import api, { Flying, SkillsType, RegionResp } from "../../../api";

interface BrushQuestionZoneType {

}
export default function BrushQuestionZone() {
  const [secondDistrictInfo, setSecondDistrictInfo] = useState(
    Array<RegionResp>
  );
  const [skills, setSkills] = useState(Array<RegionResp>);
  const [flightSkillsList, setFlightSkillsList] = useState(Array<SkillsType>);

  const [list, setList] = useState<Array<BrushQuestionZoneType>>();

  const handleChange = (value: string) => {
    console.log(`selected ${value}`);
  };
  useEffect(() => {
    setList([{}, {}, {}, {}, {}, {}]);
    api.region().then((res) => {
      setSecondDistrictInfo(res.result || []);
    });
    api.PilotLicense().then((res) => {
      setSkills(res.result || []);
    });
    api.IndustryFlightSkills().then((res) => {
      const list = res.result?.map((item) => {
        item.label = item.skillsName;
        item.value = item.id;
        return item;
      });
      setFlightSkillsList(list || []);
    });
  }, []);
  return (
    <Box>
      <div className="title">
        <Cascader
          allowClear
          placeholder="地域"
          className="selectItem"
          size="large"
          fieldNames={{
            label: "name",
            value: "id",
            children: "childInfo",
          }}
          options={secondDistrictInfo}
          // onChange={onChange}
          changeOnSelect
        />
        <Cascader
          allowClear
          placeholder="考证"
          className="selectItem"
          size="large"
          fieldNames={{
            label: "licenseType",
            value: "id",
            children: "childLicenses",
          }}
          options={skills}
          // onChange={onChange}
          changeOnSelect
        />
        <Select
          className="selectItem"
          popupMatchSelectWidth={false}
          placeholder="技能"
          size="large"
          // onChange={(value) => onProvinceChange(value, "技能")}
          options={flightSkillsList}
          fieldNames={{ value: "id", label: "skillsName" }}
          allowClear
        />
        <Cascader
          allowClear
          placeholder="选择课程"
          className="selectItem"
          style={{ width: 200 }}
          size="large"
          fieldNames={{
            label: "name",
            value: "id",
            children: "childInfo",
          }}
          options={secondDistrictInfo}
          // onChange={onChange}
          changeOnSelect
        />
      </div>
      <div className="content">
        {list?.map((item, i) => (
          <div key={i} className="item">
            <div className="img-box"></div>
            <div className="item-content">
              第一章 第1节 习题练习习题练习习题练习
            </div>
          </div>
        ))}
      </div>
    </Box>
  );
}
