import React, { Suspense } from "react";
import { Layout, Space } from "antd";
import NavHeader from "~/components/NavHeader";
import FooterView from "~/components/footer";

const { Header, Footer, Content } = Layout;

const headerStyle: React.CSSProperties = {
  height: "auto",
  background: "none",
  padding: 0,
  lineHeight: "1",
  position: "relative",
};

const contentStyle: React.CSSProperties = {
  minHeight: 120,
  lineHeight: "1",
  color: "",
  backgroundColor: "",
  width: 1200,
  position: "relative",
  margin: "0 auto",
};

const footerStyle: React.CSSProperties = {
  width:"100%",
  color: "",
  backgroundColor: "",
  lineHeight: "1",
  padding: 0,
  position: "fixed",
  bottom:0,
  // marginTop: 60,
};

type Props = {
  children?: React.ReactNode;
  layoutStyle?: React.CSSProperties;
  hideFooter?: boolean;
};

export default function LayoutView(props: Props) {
  return (
    <Space direction="vertical" style={{ width: "100%" }} size={[0, 48]}>
      <Layout
        style={Object.assign(
          { minHeight: "100vh", backgroundColor: "#F8F8F8" },
          props.layoutStyle
        )}
      >
        <Header style={headerStyle}>
          <NavHeader />
        </Header>
        <Content style={contentStyle}>{props.children}</Content>
        {!props.hideFooter && (
          <Footer style={footerStyle}>
            <FooterView></FooterView>
          </Footer>
        )}
      </Layout>
    </Space>
  );
}
