import { Col, Modal, Row } from "antd";
import Image from "next/image";
import styles from "./index.module.scss";
import img from "./assets/img.png";
import { useEffect, useState } from "react";
import api, { ListTagResp } from "./api";
import { useRouter } from "next/router";

type Props = {
  open?: boolean;
  onOk?: () => void;
  onCancel?: () => void;
};
export default function JoinModal(props: Props) {
  const router = useRouter();
  const [tagList, setTagList] = useState<ListTagResp[]>([]);

  useEffect(() => {
    api.listTag().then(res => {
      setTagList(res.result || []);
    })
  }, [])

  const onClickTag = (item: ListTagResp) => {
    router.replace("/JoinPolicy?tagId=" + item.id);
    props.onCancel && props.onCancel();
  };
  return (
    <Modal
      title="申请合作加盟"
      open={props.open}
      onOk={props.onOk}
      onCancel={props.onCancel}
      className={styles.modal}
      width={460}
      footer={null}
    >
      <Row style={{ padding: "22px 16px 20px 16px", gap: "16px 40px" }}>
        {tagList.map((item) => {
          return (
            <Col
              key={item.id}
              style={{ cursor: "pointer", height: 100, padding: 0 }}
              onClick={() => onClickTag(item)}
            >
              <Image src={img} width={100} height={100} alt=""></Image>
              <div className={styles.identityBtn}>
                {item.tagName}
                {">"}
              </div>
            </Col>
          );
        })}
      </Row>
    </Modal>
  );
}
