import React, { useEffect, useState } from "react";
import { Button, Select, Space, Tag } from "antd";
import Layout from "~/components/layout";
import styles from "./index.module.scss";
import { useRouter } from "next/router";
import Image from 'next/image';
import Filter, { FilterResult } from "~/components/filter";
import { FilterOptionResp, mallApi } from "~/components/filter/api";

// 此函数在构建时被调用
export async function getServerSideProps() {
  return {
    props: {
    },
  };
}

type Props = {
};

export default function Mall(props: Props) {
  const router = useRouter();
  const [productList, setProductList] = useState(Array<{}>);
  const onFilterChange = (filterResult: FilterResult) => {
    console.log('filterResult', filterResult)
  }
  return (
    <Layout>
      <div className="page" style={{ paddingTop: "18px" }}>
        <Filter
          types={["类目", "地域", "品牌", "部件", "型号", "成色"]}
          showResultItem
          onChange={onFilterChange}
        ></Filter>
        <div className={styles.productList}>
          <div className={styles.title}>四旋翼无人机</div>
          <div className={styles.main}>
            <ul className={styles.listWrap}>
              {productList.map((item, i) => {
                return (
                  <li
                    key={i}
                    className={styles.item}
                    onClick={() => router.push("/mall/detail/1")}
                  >
                    <Image alt="" src="" className={styles.img}></Image>
                    <div className={styles.title}>
                      入云龙ll 1550入云龙ll 1550入云龙ll 1550入云龙ll 1550
                    </div>
                    <div className={styles.sellCount}>半年售12987</div>
                  </li>
                );
              })}
            </ul>
            <div className={styles.ad}></div>
          </div>
        </div>
      </div>
    </Layout>
  );
}
