import React, { useEffect, useState } from "react";
import { useRouter } from "next/router";
import { Button, Select, Space, Tag } from "antd";
import {Box} from './styled';
import Layout from "~/components/layout";
import ContentBox from '~/components/contentBox';
import Filter, { FilterResult } from "~/components/filter";
import { FilterOptionResp } from "~/components/filter/api";

// 此函数在构建时被调用
export async function getStaticProps() {
  //获取筛选数据，进行静态渲染
  const brand = Filter.mallApi.brand();
  const category = Filter.mallApi.category();
  const model = Filter.mallApi.model();
  const part = Filter.mallApi.part();
  const quality = Filter.mallApi.quality();

  const res = await Promise.all([brand, category, part, model, quality]);

  return {
    props: {
      brandData: res[0].result || [],
      categoryData: res[1].result || [],
      partData: res[2].result || [],
      modelData: res[3].result || [],
      qualityData: res[4].result || [],
    },
  };
}

type Props = {
  brandData: Array<FilterOptionResp>;
  categoryData: Array<FilterOptionResp>;
  partData: Array<FilterOptionResp>;
  modelData: Array<FilterOptionResp>;
  qualityData: Array<FilterOptionResp>;
};

export default function EquipmentLeasing(props:Props) {
  const router = useRouter();

  const leftDom = <div className='item' onClick={() => router.push('/equipmentLeasing/detail/1')}>
    <div className="item-top">
        <div className="item-top-image"></div>
    </div>
    <div className="item-bottom">
      <div className="item-bottom-title">入云龙ll 1550入云龙ll入</div>
      <div className="item-bottom-price">
        <span className="money">¥23</span>
        <span className="unit">/天起</span>
      </div>
    </div>
  </div>

  const rightDom = <div className="right-box-item right-item">

  </div>

  const onFilterChange = (filterResult: FilterResult) => {
    console.log('filterResult', filterResult)
  }

  return  (
    <Layout>
      <Box>
        <Filter
          types={["类目", "地域", "品牌", "部件", "型号", "成色"]}
          showResultItem
          brandData={props.brandData}
          categoryData={props.categoryData}
          partData={props.partData}
          modelData={props.modelData}
          qualityData={props.qualityData}
          onChange={onFilterChange}
        ></Filter>
       <div style={{paddingTop:13}}>
        <ContentBox boxIndex={4} leftContentStyle={{width:"916px",margin:{top:0,right:"12px",bottom:"12px",left:0}}} leftRenderDom={{columns:[{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom}]}} rightRenderDom={{columns:[{element:rightDom},{element:rightDom}]}}/>
       </div>
      </Box>
    </Layout>
  )
}
