import { Space, Select } from 'antd';
import { useEffect, useState } from 'react';
import styles from '../../index.module.scss';
import api from '../../api';

export default function RegionItem(){
  const [productList, setProductList] = useState(Array<{}>);

  useEffect(() => {
    setProductList([{}, {}, {}, {}, {}, {}]);
  }, []);

  const onProvinceChange = (value: string) => {
    console.log("省", value);
  };

  const onCityChange = (value: string) => {
    console.log("市", value);
  };
  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>地域：</div>
      <div className={styles.filterItemMain}>
        <Space size={40}>
          <Select
            bordered={false}
            popupMatchSelectWidth={false}
            placeholder="选择省"
            onChange={onProvinceChange}
            options={[
              { value: "jack", label: "Jack" },
              { value: "lucy", label: "Lucy" },
              { value: "Yiminghe", label: "yiminghe" },
              { value: "disabled", label: "Disabled", disabled: true },
            ]}
          />
          <Select
            bordered={false}
            popupMatchSelectWidth={false}
            placeholder="选择市"
            onChange={onCityChange}
            options={[
              { value: "jack", label: "Jack" },
              { value: "lucy", label: "Lucy" },
              { value: "Yiminghe", label: "yiminghe" },
              { value: "disabled", label: "Disabled", disabled: true },
            ]}
          />
        </Space>
      </div>
    </div>
  ); 
}
