import request, { Response } from '~/api/request';

export interface FilterOptionResp {
  id: number,
  name: string
}

export default {
  category: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category');
  },
  brand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand');
  },
  model: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model');
  },
  part: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts');
  },
  quality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality');
  },
  region: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
}

//商城接口
export const mallApi = {
  category: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category');
  },
  brand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand');
  },
  model: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model');
  },
  part: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts');
  },
  quality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality');
  },
  region: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
}

//设备租赁接口
export const leasingApi = {
  category: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category');
  },
  brand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand');
  },
  model: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model');
  },
  part: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts');
  },
  quality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality');
  },
  region: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
}