import styled from "styled-components"

export const Box = styled.div`
    box-sizing: border-box;
    width: 1200px;
    background-color: #fff;
    padding: 42px 0 24px 24px;
    .item{
        display: flex;
        &-right{
            height: 300px;
            margin-left: 30px;
            .title{
                height: 26px;
                font-size: 28px;
                margin-top: 5px;
                font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
                font-weight: bold;
                color: #090909;
                line-height: 26px;
            }
            .function{
                display: flex;
                align-items: center;
                justify-content: space-evenly;
                width: 375px;
                height: 45px;
                margin-top: 17px;
                background: linear-gradient(90deg, #D7F7F5 0%, #EEFDE9 100%);
                &.not{
                    background: none;
                }
                &-item{
                }
            }
            .menoy{
                margin-top: 17px;
                &-left{
                    width: 79px;
                    height: 41px;
                    font-size: 32px;
                    font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
                    font-weight: bold;
                    color: #EF2E00;
                    line-height: 41px;
                }
                &-right{
                    width: 40px;
                    height: 20px;
                    font-size: 16px;
                    font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
                    font-weight: bold;
                    color: #EF2E00;
                    line-height: 20px;
                }
            }
            .classification{
                margin-top: 28px;
                width: 375px;
                height: 50px;
                .label{
                    height: 21px;
                    font-size: 16px;
                    font-family: MicrosoftYaHei;
                    color: #9A9A9A;
                    line-height: 21px;
                    margin-right: 36px;
                }
                .value{
                    height: 21px;
                    font-size: 16px;
                    font-family: MicrosoftYaHei;
                    color: #151515;
                    line-height: 21px;
                }
                .top{
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    .left{
                    }
                    .right{
                        .selectItem{
                            .ant-select-selection-placeholder {
                            color: #000;
                            }
                        }
                    }
                }
                .bottom{
                    margin-top: 5px;
                }
            }
            .botton-btn{
                margin-top: 30px;
                .btn-left{
                        width: 207px;
                        height: 40px;
                        background-color: #FFE4D1;
                        border: 1px solid #EBBAAF;
                        font-family: MicrosoftYaHei;
                        color: #FF552D;
                        letter-spacing: 1px;
                        margin-right: 12px;
                    }
                .btn-right{
                    width: 207px;
                    height: 40px;
                    background: #FF552D;
                    font-family: MicrosoftYaHei;
                    color: #FFFFFF;
                    letter-spacing: 1px;
                }
            }
        }
    }

    .flow-path{
        width: 100%;
        height: 192px;
        text-align: center;
        margin-top: 72px;
        .image{
            margin: 0 auto;
        }
    }
    .prompt{
        width: 420px;
        height: 25px;
        font-size: 20px;
        font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
        font-weight: bold;
        color: #2B2B2B;
        line-height: 25px;
        margin: 30px auto 58px auto;
    }
    .divider {
        display: flex;
        justify-content: center;
        margin: 46px 0 30px !important;

        &::before {
            width: 65px !important;
        }

        &::after {
            width: 65px !important;
        }

        .ant-divider-inner-text {
            font-size: 16px;
            font-family: PingFangSC-Regular, PingFang SC;
            font-weight: 400;
            color: #989898;
        }
    }
    .application{
        .title{
            display: flex;
            align-items: center;
            padding-bottom: 25px;
            .left{
                width: 58px;
                height: 58px;
                background: #D8D8D8;
                border-radius: 2px;
            }
            .right{
                margin-left: 15px;
                .top{
                    .tag{
                        font-size: 14px;
                        font-family: PingFangSC-Regular, PingFang SC;
                        font-weight: 400;
                        color: #FF0F0F; 
                    }
                    .money{
                        font-size: 22px;
                        font-family: PingFangSC-Medium, PingFang SC;
                        font-weight: 500;
                        color: #FF0F0F;
                    }
                    .unit{
                        font-size: 12px;
                        font-family: PingFangSC-Regular, PingFang SC;
                        font-weight: 400;
                        color: #FF0F0F;
                    }
                }
                .bottom{
                    width: 65px;
                    height: 18px;
                    font-size: 13px;
                    font-family: PingFangSC-Regular, PingFang SC;
                    font-weight: 400;
                    color: #121212;
                    line-height: 18px;
                }
            }
        }
    }
`