import request, { Response } from '~/api/request';

export interface GetWebDeviceDetailParams {
  id:number
}

export interface WareImgsType {
  id: number,
  wareInfoId: number | null,
  imgUrl: string,
  imgType: number
}

export interface GetWebDeviceDetailResult {
      id: number,
      wareNo: string,
      wareTitle: string,
      wareTypeId: number,
      wareStatus: number,
      payStatus: number,
      minDeposit: number,
      maxDeposit: number,
      minRent: number,
      maxRent: number,
      totalStock: number,
      totalSale: number,
      skuNum: number,
      tags: [
        string,
        string
      ],
      wareImgs: Array<WareImgsType>,
      warePropDTO: number | null,
      wareDetailContent: string | TrustedHTML
}


export interface PriceList {
  id: number,
  wareInfoId: number,
  skuInfoId: number,
  rentPrice: number,
  minDay: number,
  maxDay: number,
  createTime: null
} 
export interface GetWebDeviceWareSkuById {
  id: number,
  wareInfoId: number,
  skuTitle: string,
  rentPrice: number | null,
  rentDeposit: number,
  stockNum: number,
  saleNum: number,
  createTime: string,
  updateTime: null,
  skuPriceDTOList: Array<PriceList>,
}

export interface WebDeviceUpdateParams {
  id?:number,
  inventoryId?:number,
  inventoryUsage?:string,
  startDay?:string
  endDay?:string,
}

export default {
  //web-设备租赁-详情
  listDetailDeviceInfo: (params: GetWebDeviceDetailParams): Promise<Response<GetWebDeviceDetailResult>> => {
    return request('/pms/webDevice/detail', 'get', params)
  },
  //web-设备租赁-商品
  listWareSkuById: (params: GetWebDeviceDetailParams): Promise<Response<GetWebDeviceWareSkuById[]>> => {
    return request('/pms/appDevice/listWareSkuById', 'get', params)
  },
  //web-设备租赁-立即租赁
  listWareSkuUpdate: (params: WebDeviceUpdateParams): Promise<Response<number>> => {
    return request('/pms/appDevice/update', 'post', params)
  }
}