import React from "react";
import { ConfigProvider } from "antd";
import zhCN from "antd/locale/zh_CN";
import dayjs from 'dayjs';
import "dayjs/locale/zh-cn";

dayjs.locale("zh-cn");

const withTheme = (node: JSX.Element) => (
  <>
    <ConfigProvider
      locale={zhCN}
      theme={{
        token: {
          colorPrimary: "rgba(255, 85, 45, 1)",
        },
      }}
    >
      <ConfigProvider
        theme={{
          token: {
            borderRadius: 6,
            colorLink: "#333",
            colorLinkHover: "#ff552d",
          },
        }}
      >
        {node}
      </ConfigProvider>
    </ConfigProvider>
  </>
);

export default withTheme;