import request, { Response } from '~/api/request';

export interface QueryOrderTaskListParams {
  orderStatus?: number;
  pageNo: number;
  pageSize: number;
}

export interface QueryOrderTaskListResp {
  pageNo: number;
  pageSize: number;
  list: OrderList[];
  totalCount: number;
  totalPage: number;
}

export interface OrderList {
  id: number;
  address: string;
  city: string;
  endTime: string;
  images: any[];
  inspectionId: number;
  lat: number;
  lon: number;
  orderAmt: number;
  orderName: string;
  orderStatus: number;
  orderNo: string;
  province: string;
  startTime: string;
  taskDescription: string;
  coverPlan: string;
}

export interface GetServiceOrderStatusResp {
  id: number;
  orderStatus: number;
  userPort: string;
  flyerPort: string;
  managePort: string;
}

export default {
  //查询服务订单列表
  queryOrderTaskList(
    params: QueryOrderTaskListParams,
    options: any,
  ): Promise<Response<QueryOrderTaskListResp>> {
    return request('/oms/app/serviceOrderTask/queryOrderTaskList', 'post', params, options);
  },

  //订单状态-字典
  getServiceOrderStatus(): Promise<Response<GetServiceOrderStatusResp[]>> {
    return request('/oms/serviceOrderTask/getServiceOrderStatus', 'POST');
  },
};
