import request, { Response } from '~/api/request';

export interface ListPublishPageParams {
  cityCode?: number;
  date?: string;
  districtCode?: number;
  pageNo: number;
  pageSize: number;
  provinceCode?: number;
}

export interface ListPublishPageResp {
  pageNo: number;
  pageSize: number;
  list: Item[];
  totalCount: number;
  totalPage: number;
}

export interface Item {
  id: number;
  requirementTypeId: number;
  userAccountId: number;
  publishName: string;
  publishPhone: string;
  requireDescription: string;
  solved?: 0 | 1;
  createTime: string;
  updateTime?: string;
}

export default {
  /**
   * 需求发布列表
   * @param params 
   * @returns 
   */
  listPublishPage(params: ListPublishPageParams, options = {}): Promise<Response<ListPublishPageResp>> {
    return request('/release/requirements/listPublishPage', 'post', params, options);
  }
}