import '../public/antd.min.css';
import '../styles/index.scss';
import type { AppProps } from 'next/app';
import withTheme from '../theme';
import { message } from 'antd';
import { useEffect } from 'react';
import Head from 'next/head';
import Script from 'next/script';
import UserProvider from '~/lib/userProvider';
import CommonProvider from '~/lib/commonProvider';

export default function App({ Component, pageProps }: AppProps) {
  const [messageApi, contextHolder] = message.useMessage();
  useEffect(() => {
    //全局消息提示
    window.messageApi = messageApi;
    //@ts-ignore
    window.onresize = function () {
      // window.document.querySelector('html')!.style.fontSize = (window.innerWidth / 1920) + 'PX';
    };
  }, []);

  return withTheme(
    <>
      <Head>
        <title>云享飞</title>
        <meta
          name='viewport'
          content='width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no'
        ></meta>
      </Head>
      <Script src='https://res.wx.qq.com/connect/zh_CN/htmledition/js/wxLogin.js'></Script>
      {contextHolder}
      <CommonProvider>
        <UserProvider>
          <Component {...pageProps} />
        </UserProvider>
      </CommonProvider>
    </>,
  );
}
