import { Button, Col, Divider, Form, Input, Row } from 'antd';
import { useRouter } from 'next/router';
import { useEffect, useState } from 'react';
import LayoutView from '~/components/layout';
import api from './api';
import styles from './index.module.scss';
import { Uploader } from '~/components/uploader';
import JoinModal from '~/components/NavHeader/joinModal';

export default function JoinPolicy() {
  const [form] = Form.useForm();
  const router = useRouter();
  const [content, setContent] = useState(''); //福利内容
  const [tagId, setTagId] = useState<number>(-1);
  useEffect(() => {
    if (router.query.tagId) {
      setTagId(Number(router.query.tagId));
      api
        .getTagById({
          id: Number(router.query.tagId),
        })
        .then((res) => {
          setContent(res.result?.tagRequire.replaceAll('\n', '<br/>') || '');
        });
    }
  }, [router.query.tagId]);
  //提交
  const submitApply = () => {
    form.validateFields().then((valid) => {
      api
        .cooperationApply({
          ...valid,
          cooperationTagId: tagId,
        })
        .then((res) => {
          if (res.code === '200') {
            window.messageApi.success('提交成功');
            form.resetFields();
            setTimeout(() => {
              router.push('/');
            }, 1500);
          }
        });
    });
  };
  //上传变更
  const uploadChange = (value: any) => {
    let attachmentList = value.map((v: any) => ({
      type: v.type.includes('image') ? 0 : 1,
      url: v.url,
    }));
    form.setFieldValue('attachmentList', attachmentList);
  };
  return (
    <LayoutView>
      <div
        className='page'
        style={{
          background: '#fff',
          position: 'relative',
          zIndex: 1,
          marginTop: 20,
          paddingBottom: 63,
        }}
      >
        <div className={styles.headerLine}></div>
        <div className={styles.font1} style={{ textAlign: 'center', marginTop: '22px' }}>
          加盟入驻
        </div>
        <Divider />
        <div className={styles.infoContent}>
          <div className={styles.tip}>
            <div className={styles.tipTitle}>需准备上传资料</div>
            <div className={styles.font2} dangerouslySetInnerHTML={{ __html: content }}></div>
          </div>
          <div className={styles.formWrap}>
            <div className={styles.formTitle}>填写资料</div>
            <div className={styles.form}>
              <Form labelCol={{ span: 2 }} wrapperCol={{ span: 10 }} labelAlign='left' form={form}>
                <Form.Item
                  label='联系人'
                  name='applyName'
                  rules={[{ required: true, message: '请输入联系人' }]}
                >
                  <Input placeholder='请输入联系人' maxLength={30} />
                </Form.Item>
                <Form.Item
                  label='联系方式'
                  name='applyPhone'
                  rules={[
                    { required: true, message: '请输入联系方式' },
                    { pattern: /^1\d{10}$/, message: '请输入正确的手机号码' },
                  ]}
                >
                  <Input placeholder='请输入联系方式' />
                </Form.Item>
                <Row>
                  <Col span={2}>
                    <div>上传资料：</div>
                  </Col>
                  <Col span={10}>
                    <div className={styles.uploadTip}>
                      <div>1. 图片格式为JPG、JPEG、BMP、GIF、PNG</div>
                      <div>2. 文档格式为word、PDF、excel</div>
                      <div> 3. 文件大小不超过10M</div>
                    </div>
                    <div className={styles.uploadOperate}>
                      <Form.Item name='attachmentList'>
                        <Uploader
                          fileUpload
                          listType='text'
                          fileLength={10}
                          fileSize={10}
                          onChange={uploadChange}
                          fileType={[
                            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                            'application/vnd.ms-excel',
                            'application/pdf',
                            'application/msword',
                            'image/png',
                            'image/jpeg',
                            'image/jpg',
                            'image/gif',
                            'image/bmp',
                          ]}
                        >
                          <Button>上传文件</Button>
                        </Uploader>
                      </Form.Item>
                    </div>
                  </Col>
                </Row>
                <Form.Item label='备注（选填）' name='remark'>
                  <Input placeholder='请输入备注' maxLength={60} />
                </Form.Item>
              </Form>
            </div>
          </div>
        </div>
        <div className={styles.submitOperate}>
          <Button type='primary' onClick={submitApply}>
            提交申请
          </Button>
        </div>
      </div>
    </LayoutView>
  );
}
JoinPolicy.getInitialProps = async () => {
  return {};
};
