import request, { Response } from "~/api/request";

export interface PublishParams {
  lat?: number; //纬度
  lon?: number; //经度
  description: string; //描述
  userId: number; //用户id
  mediaVO: {
    //发布图片
    picture: Array<string>;
  };
}

export default {
  //动态发布
  publish(params: PublishParams): Promise<Response<null>> {
    return request("/release/dynamic/publish", "post", params);
  },
};
