import { Button, Col, Divider, Form, Input, Row } from "antd";
import { useRouter } from "next/router";
import { useEffect, useState } from "react";
import LayoutView from "~/components/layout";
import api from "./api";
import styles from "./index.module.scss";

export default function JoinPolicy() {
  const router = useRouter();
  const [content, setContent] = useState(""); //福利内容
  const tagId = Number(router.query.tagId);

  useEffect(() => {
    if (tagId) {
      api
        .getTagById({
          id: tagId,
        })
        .then((res) => {
          setContent(res.result?.tagDescription.replaceAll("\n", "<br/>") || "");
        });
    }
  }, []);
  //提交
  const onFinish = (values: any) => {
    console.log(values);
    api
      .cooperationApply({
        ...values,
        cooperationTagId: tagId,
      })
      .then((res) => {
        console.log("提交结果", res);
        if (res.code === "200") {
          window.messageApi.success('提交成功');
          setTimeout(() => {
            router.push("/");
          }, 1500);
        }
      });
  };

  return (
    <LayoutView>
      <div className={styles.banner}></div>
      <div
        className="page"
        style={{
          background: "#fff",
          position: "relative",
          zIndex: 1,
          marginTop: 60,
          paddingBottom: 63,
        }}
      >
        <div
          className={styles.font1}
          style={{ textAlign: "center", paddingTop: 40, paddingBottom: 30 }}
        >
          加盟入驻福利
        </div>
        <div
          className={styles.font2}
          style={{ paddingLeft: 50, paddingRight: 50 }}
          dangerouslySetInnerHTML={{ __html: content }}
        ></div>
        <Divider />
        <div
          className={styles.font1}
          style={{ textAlign: "center", marginBottom: 28 }}
        >
          申请加盟入驻
        </div>
        <Row justify={"center"}>
          <Col style={{ width: 400 }}>
            <Form labelAlign="left" labelCol={{ span: 5 }} onFinish={onFinish}>
              <Form.Item
                label="姓名"
                name="applyName"
                rules={[{ required: true }]}
              >
                <Input placeholder="请输入姓名"></Input>
              </Form.Item>
              <Form.Item
                label="联系方式"
                name="applyPhone"
                rules={[{ required: true }]}
              >
                <Input placeholder="请输入手机号"></Input>
              </Form.Item>
              <Form.Item name="remark">
                <Input.TextArea placeholder="其它信息"></Input.TextArea>
              </Form.Item>
              <Row justify={"center"}>
                <Button
                  type="primary"
                  htmlType="submit"
                  style={{ marginTop: 11, width: 200 }}
                  size="large"
                >
                  提交申请
                </Button>
              </Row>
            </Form>
          </Col>
        </Row>
      </div>
    </LayoutView>
  );
}
