import { Space, Button, Select, Collapse } from "antd";
import styles from "../../index.module.scss";
import api, { FilterOptionResp } from "../../api";
import { useState, useEffect } from "react";

type Props = {
  onChange: (id: FilterOptionResp) => void;
};

export default function CategoryItem(props: Props) {
  const [data, setData] = useState<FilterOptionResp[]>([]);

  useEffect(() => {
    api.appType().then((res) => {
      setData(res?.result || []);
    });
  }, []);

  const onClick = (item: FilterOptionResp) => {
    props.onChange({
      id: item.id,
      appName: "应用：" + item.appName,
    });
  };

  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>应用：</div>
      <div
        className={`${styles.filterItemMain} ${
          data.length <= 10 && styles.disabled
        }`}
      >
        <Collapse ghost collapsible="icon" expandIconPosition="end">
          <Collapse.Panel
            header={
              <Space size={40}>
                {data.slice(0, 10).map((item) => {
                  return (
                    <Button
                      type="link"
                      key={item.id}
                      onClick={(e) => onClick(item)}
                    >
                      {item.appName}
                    </Button>
                  );
                })}
              </Space>
            }
            key="1"
          >
            <Space size={40}>
              {data.slice(10).map((item) => {
                return (
                  <Button
                    type="link"
                    key={item.id}
                    onClick={(e) => onClick(item)}
                  >
                    {item.appName}
                  </Button>
                );
              })}
            </Space>
          </Collapse.Panel>
        </Collapse>
      </div>
    </div>
  );
}
