import request, { Response } from '~/api/request';

export interface DynamicListParams {
  pageNo: number;
  pageSize: number;
  userId: number;
}

export interface Dynamic {
  userId: number;
  id: number;
  title: string;
  description: string;
  location: string;
  lat: number;
  lon: number;
  mediaVO: {
    picture: string[];
    videoUrl: string;
  };
  likesCount: number;
  commentCount: number;
  likes: boolean;
  userBaseInfo: {
    id: number;
    nickName: string;
    userImg: string;
  };
}

export interface DynamicListResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Dynamic>;
  totalCount: 0;
  totalPage: 0;
}

export interface CommentParams {
  content: string; //评论内容
  dynamicId: number; //动态id
  parentId?: number; //父级评论
}

export interface ByDynamicResp {
  id: number;
  dynamicId: number;
  parentId: number;
  userId: number;
  content: string;
  likesCount: number;
  createTime: string;
  children: ByDynamicResp[];
  userBaseInfoVO: {
    id: number;
    nickName: string;
    userImg: string;
  };
}

export default {
  /**
   * 论坛动态列表
   * @param params
   * @returns
   */
  dynamicList(params: DynamicListParams): Promise<Response<DynamicListResp>> {
    return request('/release/dynamic/dynamicList', 'get', params);
  },

  //评论
  comment(params: CommentParams): Promise<Response<null>> {
    return request('/release/dynamic/comment', 'post', params);
  },

  //根据动态查看评论
  byDynamic(params: { dynamicId: number }): Promise<Response<Array<ByDynamicResp>>> {
    return request('/release/dynamic/byDynamic', 'get', params);
  },

  //点赞或取消点赞
  likeOrCancel(params: { dynamicId: number }) {
    return request('/release/dynamic/likeOrCancel', 'get', params);
  },
};
