import React from 'react';

import { Rate } from 'antd';
import Moment from 'moment';
import Image from 'next/image';

import pic1 from './assets/1.webp';
import pic2 from './assets/2.webp';
import pic3 from './assets/3.webp';
import pic4 from './assets/4.webp';
import pic5 from './assets/5.webp';
import pic6 from './assets/6.webp';
import pic7 from './assets/7.webp';
import pic8 from './assets/8.webp';
import pic9 from './assets/9.webp';
import { Box } from './styled';
import { JobDetail } from '../../api';

const imgList = [pic1, pic2, pic3, pic4, pic5, pic6, pic7, pic8, pic9];

const name = [
  '浮生若梦',
  '惜君嫣云',
  '抹茶味儿的菇凉',
  '清歌缈缦',
  '清新雅致',
  '呆到深处自然萌',
  '各不打扰',
  '无声飞雪',
  '浅笑小倔强',
  '乱了夏末蓝了海',
  '初夏知鸣',
];

interface EvaluateType {
  evaluateInfo: Array<JobDetail>;
}

export default function Evaluate(props: EvaluateType) {
  const { evaluateInfo } = props;

  const listVal: Array<JobDetail> = JSON.parse(JSON.stringify(evaluateInfo));
  listVal.map((item, index) => {
    item.img = imgList[Math.floor(Math.random() * 9)]?.src;
    item.name = name[Math.floor(Math.random() * 12)];
    console.log(Date.now() - index * 100000);
    item.time = Date.now() - index * 8e7;
  });

  return (
    <Box>
      {listVal?.map((item, i) => (
        <div key={item.id} className='item'>
          <div className='item-user'>
            <div className='item-user-image'>
              <Image
                className='image'
                height={42}
                width={42}
                src={item.img ? item.img : ''}
                alt='#'
              />
            </div>
            <div className='item-user-info'>
              <div className='item-user-info-name'>{item.name}</div>
              <Rate style={{ height: 30 }} disabled defaultValue={item.star} />
            </div>
          </div>
          <div className='item-content'>
            <div className='item-content-label'>{item.content}</div>
            <div className='item-content-image'>
              {item.contentImgs?.length
                ? item.contentImgs?.map((item) => (
                    <div key={item} className='image-item'>
                      <Image width={80} height={80} src={item} alt='error' />
                    </div>
                  ))
                : null}
            </div>
            <div className='item-content-time'>{Moment(item.time).format('YYYY-MM-DD')}</div>
          </div>
        </div>
      ))}
    </Box>
  );
}
