import request, { Response } from '~/api/request';

export interface CompanyAuthParams {
  companyName: string;
  creditCode: string;
  licenseImg: string;
  userAccountId: number;
  authStatus: 1 | 0;
}

export interface FuzzyQueryCompanyResp {
  Status: string;
  Message: string;
  OrderNumber: string;
  Paging: Paging;
  Result: EnterpriseInfo[];
}

export interface EnterpriseInfo {
  KeyNo: string;
  Name: string;
  CreditCode: string;
  StartDate: string;
  OperName: string;
  Status: string;
  No: string;
  Address: string;
  label: string;
  value: string;
}

export interface Paging {
  PageSize: number;
  PageIndex: number;
  TotalRecords: number;
}

export default {
  // 提交企业认证
  companyAuth(params: CompanyAuthParams): Promise<Response<string>> {
    return request('/userapp/company-auth/add', 'post', params);
  },

  // 企业工商模糊搜索
  fuzzyQueryCompany(params: { searchKey: string }): Promise<Response<FuzzyQueryCompanyResp>> {
    return request('/userapp/company-auth/fuzzyQueryCompany', 'get', params);
  },
};
