import { Modal, ModalProps } from 'antd';
import { FC, useEffect, useState } from 'react';
import { Box } from './styled';
import api from '~/api';
import { Image } from 'antd';
const WxCodeModal: FC<ModalProps> = ({ open, onCancel }) => {
  const [wxCodeImg, setWxCodeImg] = useState<string>('');
  const getWXCode = () => {
    api.listBannerImg('WX_CODE').then(({ result }) => {
      if (result) {
        setWxCodeImg(result[0].bannerImg);
      }
    });
  };
  useEffect(() => {
    getWXCode();
  }, []);
  return (
    <Modal open={open} onCancel={onCancel} width={400} footer={null}>
      <Box>
        <div className='title'>立即申请合作</div>
        <div className='img'>
          <Image src={wxCodeImg} width={160} height={160} />
        </div>
        <div className='meta'>打开微信扫一扫</div>
      </Box>
    </Modal>
  );
};
export default WxCodeModal;
