import request, { Response } from "~/api/request"

export interface GetAppGoodsInfoDetailParams {
  id: number
}

export interface GetAppGoodsInfoDetailResult {
  id: number;
  pid?: number;
  goodsName?: string;
  shareFlyServiceId?: number;
  repoId?: number;
  goodsSpec?: GoodsSpec[];
  images?: Image[];
  goodsVideo?: string;
  goodsVideoId?: number;
  goodsDetail?: GoodsDetail;
  sortTypeId?: number;
  masterTypeId?: number;
  slaveTypeId?: number;
  tag?: string;
  shelfStatus?: number;
  otherService?: OtherService[];
  question?: Question[];
  goodsDesc?: string
}

export interface GoodsDetail {
  id: number;
  goodsDesc: string;
  content: string;
  remark?: any;
}

export interface Image {
  id: number;
  imgUrl: string;
  imgType: number;
}

export interface GoodsSpec {
  id: number;
  goodsSpecName: string;
  goodsTypeId: number;
  typeName: string;
  skuId: number;
  brandInfoId: number;
  skuName: string;
  productSpecList: ProductSpecList[];
  industrySpecList?: any;
  chooseType: number;
  skuUnitId: number;
  unitName: string;
  must: number;
  flag?: any;
}

export interface ProductSpecList {
  id: number;
  productSpec: number;
  productSkuId: number;
  specName: string;
  specImage: string;
  partNo: string;
  versionDesc: string;
  createTime?: any;
  productSpecCPQVO?: any;
}

export interface Question {
  answer: string,
  id: number,
  question: string
}

//其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修
export interface OtherService {
  id: number,
  saleServiceId: number,
  serviceName: string
}


export default {
  //web-获取商品详细信息--共多少种选择
  getAppGoodsInfoDetail(params: GetAppGoodsInfoDetailParams): Promise<Response<GetAppGoodsInfoDetailResult>> {
    return request('/pms/webProductMall/getAppGoodsInfoDetail', 'get', params)
  }
}