
import config from './config';
/**
 * 请求封装
 * @param url 请求url
 * @param method 请求方法类型
 * @param data 请求的参数
 * @param options 额外参数
 * @returns Promise<Response>
 */
export default function request(url: string, method: String = 'get', data?: any, options = {}): Promise<Response<any>> {

  switch (method.toLowerCase()) {
    case 'get':
      let params = new URLSearchParams();
      if (data) {
        Object.keys(data).forEach((key) => {
          params.append(key, data[key]);
        })

        url += '?' + params;
      }
      break;

    case 'post':
      options = {
        ...options,
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
      }
      break;
  }

  return fetch(config.baseUrl + url, options)
    .then((r) => {
      try{
        return r.json()
      }catch(e){
        console.error(e);
      }
      return {
        code: '-1',
        message: '请求失败',
        result: null
      }
    })
    .then((data) => {
      return data;
    })
    .catch(error => {
      if (error.name === 'AbortError') {
        console.log('请求已中断');
        console.log(error);
      } else {
        console.error('请求出错', error);
      }
      return {
        code: '-1',
        message: '请求失败',
        result: null
      }
    });
}

//准备响应结构
export interface Response<T> {
  code: string,
  message: string,
  result?: T | null
}