import React from 'react';
import { Carousel } from 'antd';
import { Box } from './styled';
import Image from 'next/image';

export default function RotationChart() {
  const list = [
    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/da9ebaef-8dfb-4daf-930a-155f21c7351b.jpg',
    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/150654a8-64bc-4888-a8b9-b35d812f60c2.jpg',
    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/a93492b7-7b60-43c0-ad51-86262b87b4de.jpg',
    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/a0dc9062-cef8-44ce-bbba-ee82a0d5fe80.jpg',
    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/95843a99-e8bf-4156-b47a-cf3720f4a885.jpg',
  ];
  return (
    <Box>
      <Carousel className='rotationChart' autoplay dots={{ className: 'botsBotton' }}>
        {list.map((item) => (
          <div key={item}>
            <h3 className='contentStyle'>
              <Image src={item} alt='error' fill />
            </h3>
          </div>
        ))}
      </Carousel>
    </Box>
  );
}
