import request, { Response } from '~/api/request';

export interface ListPageDeviceInfoParams {
  brandId?: number;
  districtId?: number;
  modelId?: number;
  pageNo: number;
  pageSize: number;
  partsId?: number;
  productCategoryId?: number;
  qualityId?: number;
}

export interface Device {
  id: number;
  goodsName: string;
  images: string;
  price: number | null;
}

export interface Advertisement {
  id: number;
  imageUrl: string;
}

export interface ListPageDeviceInfoResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Device>;
  totalCount: 0;
  totalPage: 0;
}

export default {
  //web-设备租赁-分页
  listPageDeviceInfo: (
    params: ListPageDeviceInfoParams,
    options = {},
  ): Promise<Response<ListPageDeviceInfoResp>> => {
    return request('/pms/product/mall/deviceList', 'post', params, options);
  },
  //web-设备租赁-广告
  listAdvertisementInfo: (): Promise<Response<Array<Advertisement>>> => {
    return request('/pms/webDevice/ad', 'get');
  },
};
