import request, { Response } from "~/api/request"

export interface ListPageParams {
  keyword?: string,
  showType: number,
  pageNo: number;
  pageSize: number;
}

export interface ListPageResp {
  pageNo: number;
  pageSize: number;
  list: OrderList[];
  totalCount: number;
  totalPage: number;
}

export interface OrderList {
  id: number;
  orderNo: string;
  orderMainImg: string;
  orderName: string;
  totalBuyNum: number;
  orderAmount: number;
  statusCode: number;
  signStatus?: any;
  operationName?: any;
  operationId?: any;
  deliveryTime?: any;
  contractNo?: any;
  userAccountId: number;
  uid?: any;
  userName?: any;
  phoneNum?: any;
  payMethod: number;
  contractSignedWay?: any;
  createTime: string;
  recMallUserName?: any;
  ogSkuSpecDTOList: OgSkuSpecDTOList[];
  remark: string;
  creditPeriod?: any;
  entName?: any;
  saleId?: any;
  saleName?: any;
  tagName?: any;
  realNameAuth?: any;
  realPayAmount?: any;
  subAmount?: any;
  shareId?: any;
  shareStatus: number;
  deductAmount?: any;
  discountAmount?: any;
  realityAmount?: any;
  shutReason?: any;
  mallOrderProdListDTOList: MallOrderProdListDTOList[];
  mremark?: any;
}

interface MallOrderProdListDTOList {
  id: number;
  goodsInfoId: number;
  productName: string;
  model?: any;
  prodSkuSpecName: string;
  prodSkuSpecImage: string;
  partNo: string;
  versionDesc: string;
  buyNum: number;
  unitPrice: number;
  skuSpecAmount: number;
}

interface OgSkuSpecDTOList {
  id: number;
  directoryId: number;
  shopCarId?: any;
  skuSpecName: string;
}


export interface ListStatusResp {
  status: string;
  code: number;
  nextCode: number;
}

export default {
  //v1.0.0订单列表-查询
  listPage(params: ListPageParams, options: any): Promise<Response<ListPageResp>> {
    return request('/oms/app-order/listPage', 'get', params, options)
  },

  //订单状态-字典
  listStatus(): Promise<Response<ListStatusResp[]>> {
    return request('/oms/mallorder/listStatus', 'get');
  }
}