import { Col, Modal, Row } from "antd";
import Image from "next/image";
import styles from "./index.module.scss";
import img from "./assets/img.png";
import { useContext, useEffect, useState } from "react";
import api, { ListTagResp } from "./api";
import { useRouter } from "next/router";
import { UserContext } from "~/lib/userProvider";

const imgs = [
  require("./assets/生产制造商.png"),
  require("./assets/品牌企业.png"),
  require("./assets/商务公关机构.png"),
  require("./assets/无人机自媒体.png"),
  require("./assets/投资机构.png"),
  require("./assets/飞手团队.png"),
  require("./assets/二手服务商.png"),
  require("./assets/飞手培训机构.png"),
  require("./assets/推广合作商.png"),
];

type Props = {
  open?: boolean;
  onOk?: () => void;
  onCancel?: () => void;
};
export default function JoinModal(props: Props) {
  const router = useRouter();
  const [tagList, setTagList] = useState<ListTagResp[]>([]);
  const { userInfo } = useContext(UserContext);

  useEffect(() => {
    api.listTag().then((res) => {
      setTagList(res.result || []);
    });
  }, []);

  const onClickTag = (item: ListTagResp) => {
    if (userInfo!.companyAuthStatus) {
      router.replace("/JoinPolicy?tagId=" + item.id);
      props.onCancel && props.onCancel();
    } else {
      router.push("/certification");
    } 
  };
  return (
    <Modal
      title="申请合作加盟"
      open={props.open}
      onOk={props.onOk}
      onCancel={props.onCancel}
      className={styles.modal}
      width={460}
      footer={null}
    >
      <Row style={{rowGap: 29, paddingTop: 21, paddingBottom: 21}}>
        {tagList.map((item, i) => {
          return (
            <Col
              key={item.id}
              span={8}
              style={{
                cursor: "pointer",
                padding: 0,
                textAlign: "center",
              }}
              onClick={() => onClickTag(item)}
            >
              <Image src={imgs[i]} width={64} height={64} alt=""></Image>
              <div className={styles.identityBtn}>
                {item.tagName}
                {">"}
              </div>
            </Col>
          );
        })}
      </Row>
    </Modal>
  );
}
