import { Button, Image, Space, Input, Modal, Form } from "antd";
import Layout from "~/components/layout";
import styles from "./index.module.scss";
import errImg from "~/assets/errImg";
import { RightOutlined } from "@ant-design/icons";
import { useEffect, useState } from "react";
import PublishMessage from "./components/publishMessage";
import api, { Dynamic } from "./api";

interface Item extends Dynamic {
  openComment?: boolean; //是否开启评论
  showCommentAll?: boolean; //是否展示全部评论
}

export default function Forum() {
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [list, setList] = useState<Array<Item>>([]);
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 16,
  });

  useEffect(() => {
    api
      .dynamicList({
        userId: 1,
        ...pageParams,
      })
      .then((res) => {
        setList(res.result?.list || []);
      });
  }, []);

  /**
   * 展示发布模态框
   */
  const showModal = () => {
    setIsModalOpen(true);
  };

  /**
   * 取消发布
   */
  const onPublishCancel = () => {
    setIsModalOpen(false);
  };

  /**
   * 打开评论
   * @param item 当前点击项
   */
  const openComment = (item: Item) => {
    item.openComment = !item.openComment;
    const temp = [...list];
    setList(temp);
  };
  return (
    <Layout>
      <div className={styles.forum}>
        <div className={styles.header}>
          <div className={styles.title}>最新讨论</div>
          <Button className={styles.btn} type="primary" onClick={showModal}>
            发布动态
          </Button>
        </div>
        <Space direction="vertical" size={8} style={{width: '100%'}}>
          {list.map((item) => {
            return (
              <div key={item.id} className={styles.item}>
                <Space size={10} align="start">
                  <Image alt="" className={styles.headImg}></Image>
                  <div className={styles.info}>
                    <div className={styles.name}>给**的</div>
                    <div className={styles.desc}>{item.title}</div>
                    <div className={styles.imgs}>
                      <Image.PreviewGroup
                        preview={{
                          onChange: (current, prev) =>
                            console.log(
                              `current index: ${current}, prev index: ${prev}`
                            ),
                        }}
                      >
                        <Space size={6} wrap>
                          {item?.mediaVO?.picture?.map((img) => {
                            return (
                              <Image
                                key={img}
                                alt=""
                                className="img"
                                width={132}
                                height={132}
                                src={img}
                                fallback={errImg}
                              />
                            );
                          })}
                        </Space>
                      </Image.PreviewGroup>
                    </div>
                    <div className={styles.ctrls}>
                      <div
                        className={styles.ctrlsItem}
                        onClick={() => openComment(item)}
                      >
                        <div
                          className={`${styles.ctrlsItemIcon} ${styles.iconComment}`}
                        ></div>
                        {item.commentCount}评论
                      </div>
                      <div className={styles.ctrlsItem}>
                        <div
                          className={`${styles.ctrlsItemIcon} ${
                            styles.iconPraise
                          } ${item.likes && styles.active}`}
                        ></div>
                        {item.likesCount}赞
                      </div>
                    </div>
                  </div>
                </Space>
                {item.openComment && (
                  <div className={styles.commentWrap}>
                    <div className={styles.draftWrap}>
                      <div className={styles.commentHeadImg}>自已</div>
                      <Input
                        className={styles.commentInput}
                        placeholder="说点什么吧，万一火了呢~"
                      ></Input>
                    </div>
                    <div className={styles.btnCommentWrap}>
                      <Button type="primary" className="btnComment">
                        评论
                      </Button>
                    </div>
                    <div className={styles.comments}>
                      <div className={styles.commentItem}>
                        <div className={styles.commentHeadImg}></div>
                        <div className={styles.info}>
                          <div className={styles.nameWrap}>
                            <div className={styles.commentName}>
                              无人机爱好者111：
                              <div className={styles.date}>05-16</div>
                            </div>
                            <div className={styles.commentContent}>
                              无人机记录生活
                            </div>
                          </div>
                        </div>
                      </div>
                      <div className={styles.commentItem}>
                        <div className={styles.commentHeadImg}></div>
                        <div className={styles.info}>
                          <div className={styles.nameWrap}>
                            <div className={styles.commentName}>
                              无人机爱好者111：
                              <div className={styles.date}>05-16</div>
                            </div>
                            <div className={styles.commentContent}>
                              无人机记录生活
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    {!item.showCommentAll && (
                      <div className={styles.showAll}>
                        查看全部15条评论
                        <RightOutlined size={14} />
                      </div>
                    )}
                  </div>
                )}
              </div>
            );
          })}
        </Space>
      </div>
      <PublishMessage
        open={isModalOpen}
        onCancel={onPublishCancel}
      ></PublishMessage>
    </Layout>
  );
}
