import '../public/antd.min.css';
import '../styles/index.scss';
import type { AppProps } from 'next/app';
import withTheme from '../theme';
import { message } from 'antd';
import { useEffect } from 'react';

export default function App({ Component, pageProps }: AppProps) {
  const [messageApi, contextHolder] = message.useMessage();
  useEffect(() => {
    //全局消息提示
    window.messageApi = messageApi;
  }, [])
  
  return withTheme(
    <>
      {contextHolder}
      <Component {...pageProps} />
    </>
  );
}
