package com.mmc.pms.dao.category;

import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.entity.category.CategoryPrimaryDO;
import com.mmc.pms.entity.category.CategorySubDO;
import com.mmc.pms.model.category.qo.CategoryQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author small
 * @Date 2023/7/21 10:20
 * @Version 1.0
 */
@Mapper
public interface CategoryDao {
    int getCountName(String name);

    void addPrimaryCategory(CategoryPrimaryDO primaryDO);

    void updateSort(Integer id);

    void deletePrimaryCategory(Integer id);

    Integer categoryCount(CategoryPrimaryDO primaryDO);

    void updatePrimaryCategory(CategoryPrimaryDO primaryDO);

    int getCountSubName(String name, Integer categoryPrimaryId);

    void addSubCategory(CategorySubDO subDO);

    Integer categorySubCount(CategorySubDO subDO);

    void updateSubCategory(CategorySubDO subDO);

    void deleteSubCategory(Integer id);

    CategorySubDO detailSubCategory(Integer id);


    List<CategoryPrimaryDO> categoryList(CategoryQO param);


    List<CategorySubDO> selectSubList(Integer id);


    int categoryListCount(CategoryQO param);

    void exchange(ServiceDO serviceDO);

    List<CategoryPrimaryDO> selectPrimaryList();

    List<CategorySubDO> selectCategorySubList(List<Integer> ids);

    Integer selectSubMallGoods(Integer id);

    Integer selectPrimary(Integer id);

    List<CategoryPrimaryDO> selectPrimaryListByIds(List<Integer> ids);
}
