package com.mmc.pms.model.order.vo;

import com.mmc.pms.entity.OrderReceiptDO;
import com.mmc.pms.model.other.dto.RepoAddressDTO;
import com.mmc.pms.model.other.dto.RepoInfoDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/25 10:06 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "收货地址类")
public class OrderReceiptVO implements Serializable {
    private static final long serialVersionUID = -3695743775258866831L;

    @ApiModelProperty(value = "", hidden = true)
    private Integer id;

    @ApiModelProperty(value = "订单id")
    private Integer orderInfoId;

    @ApiModelProperty(value = "", hidden = true)
    private Integer receiptMethod;

    @ApiModelProperty(value = "", hidden = true)
    private String takeName;

    @ApiModelProperty(value = "", hidden = true)
    private String takePhone;

    @ApiModelProperty(value = "", hidden = true)
    private String region;

    @ApiModelProperty(value = "", hidden = true)
    private String detailAddress;

    @ApiModelProperty(value = "门店名称")
    private String repoName;

    @ApiModelProperty(value = "门店地址")
    private String repoAddress;

    @ApiModelProperty(value = "预留手机号")
    private String bookPhone;

    @ApiModelProperty(value = "物流公司编码")
    private String sendExCode;

    @ApiModelProperty(value = "物流单号")
    private String sendExNo;

    public void buildAddress(RepoAddressDTO d) {
        this.takeName = d.getRealName();
        this.takePhone = d.getPhoneNum();
        this.region = d.getRegion();
        this.detailAddress = d.getDetailAddress();
    }

    public void buildAddress(RepoInfoDTO d, String bookPhone) {
        this.repoName = d.getRepoName();
        this.repoAddress = d.getRepoAddress();
        this.bookPhone = bookPhone;
    }

    public OrderReceiptDO buildOrderReceiptDO() {
        return OrderReceiptDO.builder()
                .orderInfoId(this.orderInfoId)
                .sendExCode(this.sendExCode)
                .sendExNo(this.sendExNo)
                .build();
    }
}
