package com.mmc.pms.model.order.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author small @Date 2023/5/25 9:46 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "订单凭证DTO")
public class OrderVcuDTO implements Serializable {
    private static final long serialVersionUID = -7101242524092899210L;

    @ApiModelProperty(value = "ID")
    private Integer id;

    @ApiModelProperty(value = "订单ID")
    private Integer orderInfoId;

    @ApiModelProperty(value = "0:发货 1:收货 2:归还 3:平台收货")
    private Integer vcuType;

    @ApiModelProperty(value = "设备状况:0无问题 1有问题")
    private Integer vcuSatus;

    @ApiModelProperty(value = "描述-备注")
    private String remark;

    @ApiModelProperty(value = "图片集合")
    private List<String> imgs;

    @ApiModelProperty(value = "视频")
    private String videoUrl;
}
