package com.mmc.pms.entity;

import com.mmc.pms.model.lease.vo.WareSkuInfoVO;
import com.mmc.pms.model.sale.dto.SkuInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/19 19:54
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SkuInfoDO implements Serializable {
    private static final long serialVersionUID = 3684543586091477788L;
    private Integer id;
    private Integer wareInfoId;
    private String skuTitle;
    private BigDecimal rentPrice;
    private BigDecimal rentDeposit;
    private Integer stockNum;
    private Integer saleNum;
    private Integer pid;
    private Date createTime;
    private Date updateTime;

    /**
     * 辅助字段-start
     */
    private WareInfoDO wareInfo;

    private List<SkuPriceDO> skuPriceDOList;

    /**
     * 辅助字段-end
     *
     * @param d
     */

    public SkuInfoDO(WareSkuInfoVO d) {
        this.id = d.getId();
        this.skuTitle = d.getSkuTitle();
        this.rentDeposit = d.getRentDeposit();
        this.stockNum = d.getStockNum();
    }

    public SkuInfoDTO buildSkuInfoDTO() {
        return SkuInfoDTO.builder().id(this.id).wareInfoId(this.wareInfoId).skuTitle(this.skuTitle).rentPrice(this.rentPrice).rentDeposit(this.rentDeposit)
                .stockNum(this.stockNum).saleNum(this.saleNum).createTime(this.createTime).updateTime(this.updateTime)
                .skuPriceDTOList(CollectionUtils.isEmpty(this.skuPriceDOList) ? null : this.skuPriceDOList.stream().map(d -> {
                    return d.buildSkuPriceDTO();
                }).collect(Collectors.toList())).build();
    }
}
